# Tips Queue
# Maintained by Justin Blaney. Claude reads this at session start and delivers tips when relevant.
# Do not delete delivered tips — just mark them delivered so the history is preserved.

## How This Works

At the start of each session, Claude checks this file for any tips with `Status: queued`.

- **Universal** tips get delivered in the first 3 sessions, one per session, at a natural break point
- **Context-specific** tips get delivered only when the session involves that type of work
- Claude delivers at most 1 tip per session — don't overwhelm
- Tips are delivered conversationally, not as a formal announcement

Format for new tips (Justin adds at the bottom of the queue):
```
### TIP-[number]: [Short title]
Relevance: universal | email | research | reports | planning | coaching | first-week
Status: queued
Deliver when: [optional: describe the right moment]
Content: [the tip itself — write it as Claude would say it]
```

---

## Active Queue

### TIP-001: You can ask me to explain my reasoning
Relevance: universal
Status: queued
Deliver when: After completing any task in the first 3 sessions
Content: "By the way — any time I give you something and you want to understand how I got there, just say 'explain your reasoning' or 'walk me through that.' I'll show my work. It's also a good way to catch me if I've made an assumption you disagree with."

---

### TIP-002: How to give better instructions
Relevance: universal
Status: queued
Deliver when: After the first time the user accepts an output without asking for changes
Content: "One thing that makes me a lot more useful: the more context you give me upfront, the better my first draft will be. Instead of 'write me an email,' try 'write me a follow-up email to a new agent who missed their first training call — I want to be firm but not discouraging.' More context = fewer revisions."

---

### TIP-003: Save things you want to remember
Relevance: universal
Status: queued
Deliver when: After the user completes a task that produced something worth keeping
Content: "Quick reminder: I can only remember things between sessions if they're saved to a file in your folder. If we figured something out today that you want me to know next time, just say 'save that to my context' or 'add that to my notes' and I'll write it down. Otherwise it's gone when we close the chat."

---

### TIP-004: How to stop me mid-task
Relevance: universal
Status: queued
Deliver when: First time Claude starts working on a multi-step task
Content: "Since I'm about to do several things in a row — quick reminder that you can stop me at any point. Say 'wait' or 'hold on' and I'll pause and explain where I am before continuing. You don't have to let me finish if the direction looks wrong."

---

### TIP-005: Ask for options, not just answers
Relevance: email | planning | coaching
Status: queued
Deliver when: User asks Claude to write something and accepts the first version
Content: "Here's a move that works well: instead of asking me to write one version of something, ask for two or three approaches. 'Give me three ways to open this email — I'll pick the one that feels right.' It's faster than iterating from a single draft and you often end up with something better."

---

### TIP-006: Let me do research before you ask the question
Relevance: research | planning
Status: queued
Deliver when: User asks a research or analysis question
Content: "When you want me to research something, it helps to tell me what you're going to do with the information. 'Research competitor X' is okay. 'Research competitor X because I'm pitching an agent who just left them' is much better — I'll focus on what's actually useful for that situation."

---

### TIP-007: Reviewing agent performance
Relevance: coaching
Status: queued
Deliver when: User mentions agents, performance, or a coaching session
Content: "If you ever want to prep for an agent conversation, I'm good at helping you structure it. Tell me what you know about the situation — what they're struggling with, what you've tried, what outcome you want — and I'll help you map out how to run the call. I can also help you draft follow-up notes afterward."

---

### TIP-008: I can rewrite in different tones
Relevance: email | reports
Status: queued
Deliver when: User asks for any written content
Content: "If a draft I give you is close but the tone is off — too formal, too casual, too soft, too direct — just say so. 'Make this warmer' or 'make this more direct' are both things I understand. You don't have to rewrite from scratch. Just redirect me."

---

## Delivered Tips

*(Claude moves tips here after delivering them, with the date)*

---

## Tips Pending from Justin

*(Justin adds new tip ideas here — Claude will format and move them to the queue)*

